-- BA Pack 5 [Hyakkiyako-Shanhaijing-RW]
-- Character Voice Tables

-- ================================================================
-- Example
-- ================================================================
-- local VT_CHARNAME = {
--   [CHAR_SOUND_OKEY_DOKEY] = 'CharStartGame.ogg',                                       -- Starting game
--   [CHAR_SOUND_LETS_A_GO] = 'CharStartLevel.ogg',                                       -- Starting level
--   [CHAR_SOUND_GAME_OVER] = 'CharGameOver.ogg',                                         -- Game Overed
--   [CHAR_SOUND_PUNCH_YAH] = 'CharPunch1.ogg',                                           -- Punch 1
--   [CHAR_SOUND_PUNCH_WAH] = 'CharPunch2.ogg',                                           -- Punch 2
--   [CHAR_SOUND_PUNCH_HOO] = 'CharPunch3.ogg',                                           -- Punch 3
--   [CHAR_SOUND_YAH_WAH_HOO] = { 'CharJump1.ogg', 'CharJump2.ogg', 'CharJump3.ogg' },    -- First Jump Sounds
--   [CHAR_SOUND_HOOHOO] = 'CharDoubleJump.ogg',                                          -- Second jump sound
--   [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'CharTripleJump1.ogg', 'CharTripleJump2.ogg' },   -- Triple jump sounds
--   [CHAR_SOUND_UH] = 'CharBonk.ogg',                                                    -- Soft wall bonk
--   [CHAR_SOUND_UH2] = 'CharLedgeGetUp.ogg',                                             -- Quick ledge get up
--   [CHAR_SOUND_UH2_2] = 'CharLongJumpLand.ogg',                                         -- Landing after long jump
--   [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                   -- Hard wall bonk
--   [CHAR_SOUND_OOOF] = 'CharBonk.ogg',                                                  -- Attacked in air
--   [CHAR_SOUND_OOOF2] = 'CharBonk.ogg',                                                 -- Land from hard bonk
--   [CHAR_SOUND_HAHA] = 'CharTripleJumpLand.ogg',                                        -- Landing triple jump
--   [CHAR_SOUND_HAHA_2] = 'CharWaterLanding.ogg',                                        -- Landing in water from big fall
--   [CHAR_SOUND_YAHOO] = 'CharLongJump.ogg',                                             -- Long jump
--   [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                   -- Long jump wall bonk
--   [CHAR_SOUND_WHOA] = 'CharGrabLedge.ogg',                                             -- Grabbing ledge
--   [CHAR_SOUND_EEUH] = 'CharClimbLedge.ogg',                                            -- Climbing over ledge
--   [CHAR_SOUND_WAAAOOOW] = 'CharFalling.ogg',                                           -- Falling a long distance
--   [CHAR_SOUND_TWIRL_BOUNCE] = 'CharFlowerBounce.ogg',                                  -- Bouncing off of a flower spring
--   [CHAR_SOUND_GROUND_POUND_WAH] = 'CharGroundPound.ogg',                               -- Ground Pound after startup
--   [CHAR_SOUND_WAH2] = 'CharThrow.ogg',                                                 -- Throwing something
--   [CHAR_SOUND_HRMM] = 'CharLift.ogg',                                                  -- Lifting something
--   [CHAR_SOUND_HERE_WE_GO] = 'CharGetStar.ogg',                                         -- Star get
--   [CHAR_SOUND_SO_LONGA_BOWSER] = 'CharThrowBowser.ogg',                                -- Throwing Bowser
--   --DAMAGE
--   [CHAR_SOUND_ATTACKED] = 'CharDamaged.ogg',                                           -- Damaged
--   [CHAR_SOUND_PANTING] = 'CharPanting.ogg',                                            -- Low health
--   [CHAR_SOUND_PANTING_COLD] = 'CharPanting.ogg',                                       -- Getting cold
--   [CHAR_SOUND_ON_FIRE] = 'CharBurned.ogg',                                             -- Burned
--   --SLEEP SOUNDS
--   [CHAR_SOUND_IMA_TIRED] = 'CharTired.ogg',                                            -- Mario feeling tired
--   [CHAR_SOUND_YAWNING] = 'CharYawn.ogg',                                               -- Mario yawning before he sits down to sleep
--   [CHAR_SOUND_SNORING1] = 'CharSnore.ogg',                                             -- Snore Inhale
--   [CHAR_SOUND_SNORING2] = 'CharExhale.ogg',                                            -- Exhale
--   [CHAR_SOUND_SNORING3] = 'CharSleepTalk.ogg',                                         -- Sleep talking / mumbling
--   --COUGHING (USED IN THE GAS MAZE)
--   [CHAR_SOUND_COUGHING1] = 'CharCough1.ogg',                                           -- Cough take 1
--   [CHAR_SOUND_COUGHING2] = 'CharCough2.ogg',                                           -- Cough take 2
--   [CHAR_SOUND_COUGHING3] = 'CharCough3.ogg',                                           -- Cough take 3
--   --DEATH
--   [CHAR_SOUND_DYING] = 'CharDying.ogg',                                                -- Dying from damage
--   [CHAR_SOUND_DROWNING] = 'CharDrowning.ogg',                                          -- Running out of air underwater
--   [CHAR_SOUND_MAMA_MIA] = 'CharLeaveLevel.ogg'                                         -- Booted out of level
-- }

-- ================================================================
-- NPC Voices
-- Files are in Main
-- ================================================================

VT_NOVOICE = {
  [CHAR_SOUND_ATTACKED] = { 'sfx_smrpg_hit1.mp3', 'sfx_smrpg_shell.mp3', 'sfx_smw_bossstun.mp3', 'sfx_ff6_fistattack.mp3', 'sfx_smw_bossstun.mp3', 'sfx_mmx_hurt.mp3' },
  [CHAR_SOUND_DOH] = 'sfx_ml_bump.mp3',                                              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'sfx_smb3_down.mp3', 'sfx_cv3_dead.mp3', 'sfx_earthbound_dead.mp3'},
  [CHAR_SOUND_HERE_WE_GO] = { 'sfx_alttp_item.mp3', 'sfx_smrpg_specialflower.mp3', 'sfx_earthbound_good.mp3', 'sfx_kirby_1up.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'sfx_smb3_levelselect.mp3', 'sfx_sf2_stageselect.mp3' },                           -- Level Select
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                      -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'sfx_smw_jump.mp3' },                                      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                    -- Touch Fire
  [CHAR_SOUND_OOOF] = 'sfx_pm64_what.mp3',                                           -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sfx_smrpg_drop.mp3',                                         -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'sfx_ssb64_atk3.mp3' },                                 -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sfx_ssb64_atk2.mp3',                                     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sfx_ssb64_atk1.mp3',                                     -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sfx_smrpg_fireball.mp3' },                       -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'sfx_ssb64_itemthrow.mp3' },                                 -- Throw Object
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                           -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                   -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                              -- Boing
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                                         -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'sfx_ssb64_superjump.mp3' },                                -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'sfx_ssb64_superjump.mp3' },                    -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'sfx_smw_jump.mp3' },                                 -- 1st Jump(s)
}

-- ================================================================
-- Voice Tables
-- ================================================================

-- ================
-- Hyakkiyako Start
-- ================
VT_IZUNA = {
  [CHAR_SOUND_ATTACKED] = { 'izuna_dmg1.mp3', 'izuna_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'izuna_uu1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'izuna_dead1.mp3' },
  -- [CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = nil,
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'himari_atk1.mp3'},
  [CHAR_SOUND_HAHA] = 'izuna_desu.mp3', -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'izuna_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'izuna_jump2.mp3',        -- 2nd Jump + Dive Attack
  -- [CHAR_SOUND_HRMM] = 'himari_pickup.mp3', -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = nil,
  [CHAR_SOUND_LETS_A_GO] = 'izuna_nin2.mp3',   -- Level Select
  -- [CHAR_SOUND_MAMA_MIA] = 'kokona_daijobu.mp3', -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'izuna_fire.mp3' }, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'izuna_eh1.mp3',         -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'izuna_dmg3.mp3',       -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {nil,}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = nil,
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = nil,
  [CHAR_SOUND_PUNCH_HOO] = { 'izuna_atk2.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'izuna_atk4.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'izuna_atk3.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = nil,
  -- [CHAR_SOUND_SNORING2] = nil,
  -- [CHAR_SOUND_SNORING3] = nil,
  [CHAR_SOUND_SO_LONGA_BOWSER] = 'izuna_atk2.mp3',                         -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = nil, -- Boing
  [CHAR_SOUND_UH] = 'izuna_uu1.mp3',                                       -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'izuna_quickledge.mp3' },                           -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'izuna_ehh.ogg',                                 -- Falling
  [CHAR_SOUND_WAH2] = 'izuna_atk1.mp3',                                    -- Throw Object
  [CHAR_SOUND_WHOA] = 'izuna_ah1.mp3',                                     -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'izuna_nin1.mp3' },                               -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'izuna_nin1.mp3', 'izuna_atk2.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'izuna_atk1.mp3', 'izuna_jump4.mp3' }       -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = nil,
}

VT_TSUKUYO = {
  [CHAR_SOUND_ATTACKED] = { 'tsukuyo_dmg4.mp3', 'tsukuyo_dmg2.mp3', 'tsukuyo_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'tsukuyo_ah1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'tsukuyo_dead.mp3' },
  -- [CHAR_SOUND_EEUH] = {nil,}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = nil,
  -- [CHAR_SOUND_GROUND_POUND_WAH] = nil,
  [CHAR_SOUND_HAHA] = 'tsukuyo_laugh.mp3', -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'tsukuyo_star.mp3' },                 -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'tsukuyo_jump2.mp3',                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'tsukuyo_pickup.mp3',                         -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = nil,
  [CHAR_SOUND_LETS_A_GO] = 'tsukuyo_levelselect1.mp3',              -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'tsukuyo_getup.mp3',                      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'tsukuyo_dmg3.mp3', 'tsukuyo_ah3.mp3' }, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'tsukuyo_ah4.mp3',                            -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'tsukuyo_dmg1.mp3',                          -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {nil,}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = nil,
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = nil,
  [CHAR_SOUND_PUNCH_HOO] = { 'tsukuyo_atk1.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'tsukuyo_atk4.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'tsukuyo_atk3.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = nil,
  -- [CHAR_SOUND_SNORING2] = nil,
  -- [CHAR_SOUND_SNORING3] = nil,
  [CHAR_SOUND_SO_LONGA_BOWSER] = 'tsukuyo_atk1.mp3', -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = nil, -- Boing
  [CHAR_SOUND_UH] = 'tsukuyo_ah2.mp3',               -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'tsukuyo_atk2.mp3' },         -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = nil, -- Falling
  [CHAR_SOUND_WAH2] = 'tsukuyo_throw.mp3',                                                   -- Throw Object
  [CHAR_SOUND_WHOA] = 'tsukuyo_ah4.mp3',                                                     -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'tsukuyo_nin1.mp3' },                                               -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'tsukuyo_atk1.mp3' },                                   -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'tsukuyo_atk5.mp3', 'tsukuyo_atk6.mp3', 'tsukuyo_jump1.mp3' } -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = nil,
}

VT_MICHIRU = {
  [CHAR_SOUND_ATTACKED] = { 'michiru_dmg1.mp3', 'michiru_hua.mp3' },
  [CHAR_SOUND_DOH] = 'michiru_eh1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'michiru_dead1.mp3', 'michiru_dead2.mp3' },
  -- [CHAR_SOUND_EEUH] = {nil,}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = nil,
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'michiru_atk7.mp3' },
  [CHAR_SOUND_HAHA] = 'michiru_laugh.mp3', -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'michiru_star.mp3' },                    -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'michiru_jump2.mp3',                           -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'michiru_pickup.mp3',                            -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = nil,
  [CHAR_SOUND_LETS_A_GO] = { 'michiru_levelselect1.mp3' },             -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'michiru_getup.mp3',                         -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'michiru_fire1.mp3', 'michiru_fire2.mp3' }, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'michiru_eh1.mp3',                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'michiru_dmg2.mp3',                             -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {nil,}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = nil,
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = nil,
  [CHAR_SOUND_PUNCH_HOO] = { 'michiru_atk4.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'michiru_atk7.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'michiru_atk5.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = nil,
  -- [CHAR_SOUND_SNORING2] = nil,
  -- [CHAR_SOUND_SNORING3] = nil,
  [CHAR_SOUND_SO_LONGA_BOWSER] = 'michiru_atk2.mp3',                                          -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'michiru_huhn.mp3' },                                         -- Boing
  [CHAR_SOUND_UH] = 'michiru_ah1.mp3',                                                        -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'michiru_atk1.mp3' },                                                  -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'michiru_fall.mp3',                                                 -- Falling
  [CHAR_SOUND_WAH2] = 'michiru_throw.mp3',                                                    -- Throw Object
  [CHAR_SOUND_WHOA] = 'michiru_are1.mp3',                                                     -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'michiru_shuba.mp3' },                                               -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'michiru_atk2.mp3' },                                    -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'michiru_jump1.mp3', 'michiru_atk1.mp3', 'michiru_jump3.mp3' } -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = nil,
}

VT_CHISE = {
  [CHAR_SOUND_ATTACKED] = { 'chise_dmg1.mp3', 'chise_dmg2.mp3', 'chise_dmg3.mp3' },
  [CHAR_SOUND_DOH] = 'chise_uh1.mp3',            -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'chise_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'chise_slowclimb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'chise_note1.mp3'},
  [CHAR_SOUND_HAHA] = { 'chise_note2.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'chise_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'chise_atk-jump1.mp3' }, -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'chise_grab.mp3',            -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'silent.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'chise_ls1.mp3' },    -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'chise_getup.mp3',       -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'chise_fire1.mp3' },    -- Touch Fire
  [CHAR_SOUND_OOOF] = 'chise_uh2.mp3',             -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'chise_dmg3.mp3',           -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3',}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'chise_atk1.mp3' },  -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'chise_atk2.mp3',      -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'chise_atk-jump2.mp3', -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'chise_bthrow1.mp3', 'chise_bthrow2.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'silent.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'chise_eh1.mp3',                                           -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'chise_uh3.mp3' },                                      -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'chise_fall.mp3',                                    -- Falling
  [CHAR_SOUND_WAH2] = 'chise_throw1.mp3',                                      -- Throw Object
  [CHAR_SOUND_WHOA] = 'chise_uh3.mp3',                                         -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'chise_longjump.mp3' },                               -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'chise_jump2.mp3' },                      -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'chise_jump1.mp3', 'chise_atk-jump2.mp3' },     -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'chise_yawn.mp3' },
}

VT_KAHO = {
  [CHAR_SOUND_ATTACKED] = { 'kaho_hurt3.ogg', 'kaho_hurt1.ogg' },
  [CHAR_SOUND_DOH] = 'kaho_hurt4.ogg',                                   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'kaho_defeat1.ogg' },
  [CHAR_SOUND_HAHA] = { 'kaho_ehehe.ogg' },                            -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'kaho_yokata.ogg', 'kaho_kawai.ogg' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'kaho_ahh.ogg' },                       -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'kaho_bum.ogg',                                -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'kaho_sigh.ogg',
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'shizuko_atk6.mp3'},
  [CHAR_SOUND_LETS_A_GO] = { 'kaho_kiki.ogg' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'kaho_uhh.ogg' },                     -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'kaho_hurt2.ogg' },                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'kaho_eh2.ogg',                                    -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'kaho_sona.ogg',                                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'kaho_ya.ogg' },                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'kaho_hap.ogg',                           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'kaho_ha.ogg',                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'kaho_sodesuka.ogg' },                 -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'kaho_ehehe2.ogg' },                    -- Boing
  [CHAR_SOUND_UH] = 'kaho_eh3.ogg',                                      -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'shizuko_atk4.mp3'}, -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'kaho_hurt2.ogg',                              -- Falling
  [CHAR_SOUND_WAH2] = { 'kaho_ushimas.ogg' },                            -- Throw Object
  [CHAR_SOUND_WHOA] = 'kaho_wa2.ogg',                                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'kaho_hai2.ogg' },                            -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'kaho_hai2.ogg' },                -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'kaho_wa2.ogg' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'shizuko_yawn.mp3'},
}

VT_SHIZUKO = {
  [CHAR_SOUND_ATTACKED] = { 'shizuko_dmg2.mp3', 'shizuko_wah.mp3' },
  [CHAR_SOUND_DOH] = 'shizuko_eh.mp3',                                   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'shizuko_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'shizuko_waai.mp3' },                            -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'shizuko_star.mp3', 'shizuko_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'shizuko_jump2_1.mp3' },                       -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'shizuko_grab.mp3',                                -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'shizuko_sleep.mp3',
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'shizuko_atk6.mp3'},
  [CHAR_SOUND_LETS_A_GO] = { 'shizuko_letsGo.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'shizuko_levelFail.mp3' },                     -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'shizuko_burn.mp3' },                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'shizuko_eh.mp3',                                    -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'shizuko_dmg1.mp3',                                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'shizuko_kick.mp3' },                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'shizuko_punch2.mp3',                           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'shizuko_atk1.mp3',                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'shizuko_bowser.mp3' },                 -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                    -- Boing
  [CHAR_SOUND_UH] = 'shizuko_eh.mp3',                                      -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'shizuko_atk4.mp3'}, -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'shizuko_burn.mp3',                              -- Falling
  [CHAR_SOUND_WAH2] = { 'shizuko_throw1.mp3' },                            -- Throw Object
  [CHAR_SOUND_WHOA] = 'shizuko_wah.mp3',                                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'shizuko_yahoo.mp3' },                            -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'shizuko_yahoo.mp3' },                -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'shizuko_punch1.mp3', 'shizuko_atk1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'shizuko_yawn.mp3'},
}

VT_RENGE = {
  [CHAR_SOUND_ATTACKED] = { 'renge_dmg2.mp3', 'renge_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'renge_oh.mp3',              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'renge_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'renge_laugh.mp3' },      -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'renge_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'renge_jump2.mp3' },    -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'renge_grab.mp3',           -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'renge_sleepy.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'renge_yahoo.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'renge_letsGo.mp3' },       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'renge_levelFail.mp3' },     -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'renge_falling.mp3' },        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'renge_dmg3.mp3',                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'renge_dmg1.mp3',                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'renge_kick.mp3' },         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'renge_punch2.mp3',           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'renge_punch1.mp3',           -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'renge_bowser.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                 -- Boing
  -- [CHAR_SOUND_UH] = 'renge_are.mp3', 								-- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'renge_punch1.mp3' },                                                -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'renge_falling.mp3',                                              -- Falling
  [CHAR_SOUND_WAH2] = { 'renge_throw.mp3' },                                                -- Throw Object
  [CHAR_SOUND_WHOA] = 'renge_grab.mp3',                                                     -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'renge_yahoo.mp3' },                                               -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'renge_yahoo.mp3', 'renge_kick.mp3' },                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'renge_punch1.mp3', 'renge_punch2.mp3', 'renge_jump2.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'renge_sleepy.mp3'},
}

VT_KIKYOU = {
  [CHAR_SOUND_ATTACKED] = { 'kikyou_dmg2.mp3', 'kikyou_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'kikyou_ugh.mp3',             -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'kikyou_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'kikyou_laugh.mp3' },      -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'kikyou_star.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'kikyou_punch2.mp3' },   -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'kikyou_grab.mp3',           -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'kikyou_sleepy.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'kikyou_yahoo.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'kikyou_letsGo.mp3' },                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'kikyou_levelFail.mp3' },                    -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'kikyou_ugh.mp3' },                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'kikyou_ugh.mp3',                                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'kikyou_dmg1.mp3',                                -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'kikyou_yahoo.mp3' },                       -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'kikyou_punch2.mp3',                          -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'kikyou_kick.mp3',                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'kikyou_bowser.mp3' },                -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                 -- Boing
  [CHAR_SOUND_UH] = 'kikyou_dmg2.mp3',                                   -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'kikyou_jump1.mp3' },                             -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'kikyou_dmg1.mp3',                             -- Falling
  [CHAR_SOUND_WAH2] = { 'kikyou_throw.mp3' },                            -- Throw Object
  [CHAR_SOUND_WHOA] = 'kikyou_grab.mp3',                                 -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'kikyou_yahoo.mp3' },                           -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'kikyou_yahoo.mp3' },               -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'kikyou_jump1.mp3', 'kikyou_jump2.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'kikyou_yawn.mp3'},
}

VT_NAGUSA = {
  [CHAR_SOUND_ATTACKED] = { 'nagusa_dmg1.mp3', 'nagusa_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'nagusa_ah.mp3',                                   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'nagusa_KO1.mp3' },
  [CHAR_SOUND_HAHA] = { 'nagusa_laugh.mp3' },                           -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'nagusa_star1.mp3', 'nagusa_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'nagusa_atk5.mp3' },                          -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                         -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'nagusa_rest.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'nagusa_atk5.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'nagusa_levelselect.mp3' }, -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'nagusa_levelexit.mp3' },    -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'nagusa_huh.mp3',                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'nagusa_dmg1.mp3',                -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'nagusa_atk2.mp3' },        -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'nagusa_atk4.mp3',            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'nagusa_atk3.mp3',            -- 1st Punch
  ---[CHAR_SOUND_SO_LONGA_BOWSER] = { 'nothing' },                -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = { 'nothing' },                 -- Boing
  [CHAR_SOUND_UH] = 'nagusa_huh.mp3',                                                     -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'nagusa_atk4.mp3' },                                               -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'nagusa_dmg1.mp3',                                              -- Falling
  [CHAR_SOUND_WAH2] = { 'sfx_ssb64_itemthrow.mp3' },                                      -- Throw Object
  [CHAR_SOUND_WHOA] = 'nagusa_ah.mp3',                                                    -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'nagusa_atk2.mp3' },                                             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'nagusa_atk2.mp3' },                                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'nagusa_atk3.mp3', 'nagusa_atk6.mp3', 'nagusa_atk1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'nothing'},
}

VT_YUKARI = {
  [CHAR_SOUND_ATTACKED] = { 'yukari_dmg3.mp3', 'yukari_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'yukari_bonk.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'yukari_dead1.mp3', 'yukari_dead2.mp3' },
  -- [CHAR_SOUND_EEUH] = {'ichika_ledgeclimb.mp3'}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'ksm_bagon.mp3'},
  [CHAR_SOUND_HAHA] = { 'yukari_desuno.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'yukari_star1.mp3', 'yukari_star2.mp3', 'yukari_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'yukari_atk1.mp3' },                                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'yukari_objectgrab.mp3',                                              -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'ichika_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'yukari_ls1.mp3' },                                            -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'yukari_getup.mp3' },                                           -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'yukari_burn.mp3' },                                             -- Touch Fire
  [CHAR_SOUND_OOOF] = 'yukari_huh.mp3',                                                     -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'yukari_dmg3.mp3',                                                   -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'yukari_atk2.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'yukari_atk1.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'yukari_atk4.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'yukari_throw2.mp3', 'yukari_throw1.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'yukari_huhun.mp3' },                          -- Boing
  [CHAR_SOUND_UH] = 'yukari_huh.mp3',                                          -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'mine_atk3.mp3'}, -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'yukari_dmg2.mp3',                           -- Falling
  [CHAR_SOUND_WAH2] = { 'yukari_throw1.mp3' },                         -- Throw Object
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                           -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'yukari_atk3.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'yukari_atk2.mp3' },              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'yukari_atk4.mp3', 'yukari_atk1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'mmr_yawn.mp3'},
}

VT_WAKAMO = {
  [CHAR_SOUND_ATTACKED] = { 'wkm_dmg1.mp3', 'wkm_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'wkm_ara1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'wkm_dead1.mp3' },
  -- [CHAR_SOUND_EEUH] = {'young_slowclimb.mp3'}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'.mp3'},
  [CHAR_SOUND_HAHA] = { 'wkm_laugh3.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'wkm_star1.mp3', 'wkm_star2.mp3', 'wkm_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'wkm_atk4.mp3' },                                        -- 2nd Jump + Dive Attack
  -- [CHAR_SOUND_HRMM] = 'young_heavy.mp3', -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'young_imatired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'wkm_ls1.mp3' },  -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'wkm_getup.mp3' }, -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'wkm_dmg4.mp3' },   -- Touch Fire
  [CHAR_SOUND_OOOF] = 'wkm_ara2.mp3',          -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'wkm_dmg6.mp3',         -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'wkm_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'wkm_atk1.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'wkm_atk2.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'wkm_bthrow1.mp3', 'wkm_bthrow2.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'wkm_laugh2.mp3' },                        -- Boing
  -- [CHAR_SOUND_UH] = 'young_idk.mp3', -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'wkm_atk2.mp3' },                                   -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'wkm_throw1.mp3' },            -- Throw Object
  [CHAR_SOUND_WHOA] = 'wkm_ara1.mp3',                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'wkm_atk3.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'wkm_atk3.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'wkm_atk2.mp3' },       -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'shun_yawn.mp3'},
}

VT_PINA = {
  [CHAR_SOUND_ATTACKED] = { 'Pina_kh.ogg', 'Pina_Damage_3.ogg' },
  [CHAR_SOUND_DOH] = 'Pina_kh.ogg',                                                                    -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Pina_defeat.ogg' },
  [CHAR_SOUND_HERE_WE_GO] = { 'Pina_hashimemashte.ogg', 'Pina_Victory_2.ogg', 'Pina_Victory_3.ogg', }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'Pina_hashimemashte.ogg' },                                               -- Level Select
  [CHAR_SOUND_HRMM] = 'Pina_kh2.ogg',                                                                  -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'Pina_hai.ogg' },                                                            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'Pina_Damage_2.ogg' },                                                      -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Pina_ah.ogg',                                                                   -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Pina_ah2.ogg',                                                                 -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Pina_hasha.ogg' },                                                       -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Pina_hey.ogg',                                                             -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Pina_yah.ogg',                                                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Pina_Koki.ogg' },                                                  -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'Pina_hasha.ogg' },                                                            -- Throw Object
  [CHAR_SOUND_UH] = 'Pina_ah.ogg',                                                                     -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'Pina_Damage_3.ogg',                                                         -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'Pina_laugh.ogg' },                                                    -- Boing
  [CHAR_SOUND_WHOA] = 'Pina_ah.ogg',                                                                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Pina_hey.ogg' },                                                             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Pina_hey.ogg' },                                                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Pina_ha.ogg' },                                                        -- 1st Jump(s)
  [CHAR_SOUND_HAHA] = 'Pina_laugh.ogg',
  [CHAR_SOUND_MAMA_MIA] = 'Pina_Damage_1.ogg',
  [CHAR_SOUND_YAWNING] = 'Pina_yawn.ogg',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'Pina_skiai.ogg' },
}

VT_UMIKA = {
  [CHAR_SOUND_ATTACKED] = { 'umika_dmg1.ogg', 'umika_dmg2.ogg' }, --
  [CHAR_SOUND_DOH] = 'umika_bonk.ogg',                            -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'umika_dying.ogg' },
  --[CHAR_SOUND_EEUH] = nil, -- Slow Ledge Climb
  --[CHAR_SOUND_GAME_OVER] = nil,
  --[CHAR_SOUND_GROUND_POUND_WAH] = { 'umika_jump3.mp3' },
  [CHAR_SOUND_HAHA] = 'umika_festival.ogg', -- Landing after backflip/triple jump
  --[CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'umika_star1.ogg', 'umika_star1.ogg' }, -- Star Get + Obtaining Power-up --
  [CHAR_SOUND_HOOHOO] = 'umika_atk1.ogg',                             -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                       -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = nil,
  [CHAR_SOUND_LETS_A_GO] = 'umika_levelselect.ogg',                   -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'umika_levelexit.ogg',                      -- Getting up after thrown out of level --
  [CHAR_SOUND_ON_FIRE] = { 'umika_burn.ogg' },                        -- Touch Fire --
  [CHAR_SOUND_OOOF] = 'umika_dmg1.ogg',                               --
  [CHAR_SOUND_OOOF2] = 'umika_dmg2.ogg',                              -- Landing After a Bonk + Thrown out of level --
  [CHAR_SOUND_PUNCH_HOO] = { 'umika_atk2.ogg' },                      -- Kick --
  [CHAR_SOUND_PUNCH_WAH] = 'umika_atk1.ogg',                          -- 2nd Punch --
  [CHAR_SOUND_PUNCH_YAH] = 'umika_atk4.ogg',                          -- 1st Punch --
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'umika_firework.ogg' },            -- Bowser Throw --
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },               -- Boing
  [CHAR_SOUND_UH] = 'umika_dmg1.ogg',                                 -- Let go off of ledge
  [CHAR_SOUND_UH2] = { 'umika_atk1.ogg' },                            -- Quick Ledge Climb
  [CHAR_SOUND_WAAAOOOW] = 'umika_fall.ogg',                           -- Falling
  [CHAR_SOUND_WAH2] = 'umika_firework.ogg',                           -- Throw Object --
  [CHAR_SOUND_WHOA] = 'umika_ledge.ogg',                              -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'umika_longjump.ogg' },                      -- Long Jump --
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'umika_longjump.ogg' },          -- 3rd Jump(s) --
  [CHAR_SOUND_YAH_WAH_HOO] = { 'umika_atk1.ogg', 'umika_atk3.ogg' },  -- 1st Jump(s) --
  --[CHAR_SOUND_YAWNING] = nil,
}

VT_MIMORI = {
  [CHAR_SOUND_ATTACKED] = { 'mmr_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'mmr_ah2.mp3',            -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'mmr_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'mmr_slowclimb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'ksm_bagon.mp3'},
  [CHAR_SOUND_HAHA] = { 'mmr_laugh1.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'mmr_star1.mp3', 'mmr_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'mmr_jump3.mp3' },                      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'mmr_grab1.mp3',                            -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'ksm_sigh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'mmr_ls1.mp3' },                     -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'mmr_getup1.mp3', 'mmr_getup2.mp3' }, -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'mmr_dmg1.mp3' },                      -- Touch Fire
  [CHAR_SOUND_OOOF] = 'mmr_ah2.mp3',                              -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'mmr_dmg1.mp3', -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'mmr_jump3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'mmr_atk1.mp3',      -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'mmr_atk2.mp3',      -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'mmr_throw1.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'ksm_boing.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'mmr_ah2.mp3',                     -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'mmr_jump1.mp3' },              -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'mmr_dmg1.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'mmr_throw1.mp3' },                        -- Throw Object
  [CHAR_SOUND_WHOA] = 'mmr_ah1.mp3',                               -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'mmr_yo.mp3' },                           -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'mmr_laugh1.mp3' },           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'mmr_jump2.mp3', 'mmr_jump4.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'mmr_yawn.mp3' },
}

VT_TSUBAKI = {
  [CHAR_SOUND_ATTACKED] = { 'Tsubaki_ATTACKED1.ogg', 'Tsubaki_ATTACKED2.ogg' },
  [CHAR_SOUND_DOH] = 'Tsubaki_UH.ogg',                                                         -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Tsubaki_DYING.ogg' },
  [CHAR_SOUND_HAHA] = { 'Tsubaki_HAHA.ogg' },                                                    -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Tsubaki_HEREWEGO1.ogg', 'Tsubaki_HEREWEGO2.ogg',},                -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'Tsubaki_LETSAGO1.ogg', 'Tsubaki_LETSAGO2.ogg' },                   -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'Tsubaki_MAMAMIA.ogg' },                                             -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'Tsubaki_HRMM.ogg',                                                         -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'Tsubaki_HOOHOO.ogg' },                                                -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'Tsubaki_ATTACKED2.ogg' },                                            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Tsubaki_OOOF2.ogg',                                                       -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Tsubaki_OOOF2.ogg',                                                      -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Tsubaki_PUNCH_HOO.ogg' },                                          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Tsubaki_PUNCH_WAH.ogg',                                              -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Tsubaki_YAH_WAH_HOO.ogg',                                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Tsubaki_WAH2.ogg' },                                         -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'Tsubaki_WAH2.ogg' },                                                    -- Throw Object
  [CHAR_SOUND_UH] = 'Tsubaki_UH.ogg',                                                            -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'Tsubaki_PUNCH_WAH.ogg' },                                                   -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'Tsubaki_WAAAOOOW.ogg',                                                -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'Tsubaki_TWIRL_BOUNCE.ogg' },                                    -- Boing
  [CHAR_SOUND_WHOA] = 'Tsubaki_OOOF2.ogg',                                                       -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Tsubaki_YAHOO.ogg' },                                                  -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Tsubaki_YAHOO_WAHA_YIPPEE.ogg' },                             -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Tsubaki_YAH_WAH_HOO.ogg', 'Tsubaki_YAH_WAH_HOO2.ogg' },          -- 1st Jump(s)
  [CHAR_SOUND_EEUH] = { 'Tsubaki_UH2.ogg' },                                                    -- Slow climb from ledge
  [CHAR_SOUND_IMA_TIRED] = 'Tsubaki_IMATIRED.ogg',                                               -- Mario feeling tired
}

VT_NIYA = {
  [CHAR_SOUND_ATTACKED] = { 'niya_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'niya_bonk.mp3',                                                         -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'niya_dead.mp3' },
  [CHAR_SOUND_HAHA] = { 'niya_niha.mp3' },                                                    -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'niya_laugh2.mp3' },                -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'niya_ara-ara.mp3' },                   -- Level Select
  --[CHAR_SOUND_MAMA_MIA] = { 'NIYA_MAMAMIA.ogg' },                                             -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'niya_nyaha.mp3',                                                         -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'sfx_smw_jump.mp3' },                                                -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'niya_burn.mp3' },                                            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'niya_bonk.mp3',                                                       -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'niya_dmg1.mp3',                                                      -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'sfx_ssb64_atk3.mp3' },                                          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sfx_ssb64_atk2.mp3',                                              -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sfx_ssb64_atk1.mp3',                                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'niya_bthrow.mp3' },                                         -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'niya_throw.mp3' },                                                    -- Throw Object
  [CHAR_SOUND_UH] = 'niya_eh.mp3',                                                            -- Drop off of ledge + Fall off Ledge
  --[CHAR_SOUND_UH2] = { 'NIYA_PUNCH_WAH.ogg' },                                                   -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'niya_dmg1.mp3',                                                -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                    -- Boing
  [CHAR_SOUND_WHOA] = 'niya_eh.mp3',                                                       -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'niya_niha.mp3' },                                                  -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'niya_laugh1.mp3', 'niya_hehe.mp3' },                             -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'sfx_smw_jump.mp3' },          -- 1st Jump(s)
  --[CHAR_SOUND_EEUH] = { 'NIYA_UH2.ogg' },                                                    -- Slow climb from ledge
  [CHAR_SOUND_IMA_TIRED] = 'niya_rest.mp3',                                               -- Mario feeling tired
}
-- ================
-- Hyakkiyako End
-- ================
-- ================
-- Shanhaijing Start
-- ================
VT_KOKONA = {
  [CHAR_SOUND_ATTACKED] = { 'kokona_dmg4.mp3', 'kokona_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'kokona_ah2.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'kokona_dead1.mp3' },
  --[CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = nil,
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'kokona_atk6.mp3' },
  [CHAR_SOUND_HAHA] = 'kokona_laugh.mp3', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'kokona_starget1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'kokona_jump2.mp3',            -- 2nd Jump + Dive Attack
  --[CHAR_SOUND_HRMM] = nil, -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = nil,
  [CHAR_SOUND_LETS_A_GO] = 'kokona_levelselect.mp3', -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'kokona_daijobu.mp3',      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'kokona_onfire.mp3' },    -- Touch Fire
  [CHAR_SOUND_OOOF] = 'kokona_eh1.mp3',
  [CHAR_SOUND_OOOF2] = 'kokona_dmg2.mp3',            -- Landing After a Bonk + Thrown out of level
  --[CHAR_SOUND_PANTING] = nil, -- Low Health
  --[CHAR_SOUND_PANTING_COLD] = nil,
  --[CHAR_SOUND_PRESS_START_TO_PLAY] = nil,
  [CHAR_SOUND_PUNCH_HOO] = { 'kokona_atk1.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'kokona_atk3.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'kokona_atk2.mp3',     -- 1st Punch
  --[CHAR_SOUND_SNORING1] = nil,
  --[CHAR_SOUND_SNORING2] = nil,
  --[CHAR_SOUND_SNORING3] = nil,
  [CHAR_SOUND_SO_LONGA_BOWSER] = 'kokona_atk1.mp3', -- Bowser Throw
  --[CHAR_SOUND_TWIRL_BOUNCE] = nil, -- Boing
  [CHAR_SOUND_UH] = 'kokona_ah1.mp3',               -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'kokona_atk2.mp3' },         -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  --[CHAR_SOUND_WAAAOOOW] = nil, -- Falling
  [CHAR_SOUND_WAH2] = 'kokona_atk2.mp3',                                                   -- Throw Object
  [CHAR_SOUND_WHOA] = 'kokona_ah1.mp3',                                                    -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'kokona_atk1.mp3' },                                              -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'kokona_atk3.mp3' },                                  -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'kokona_jump7.mp3', 'kokona_atk6.mp3', 'kokona_atk5.mp3' }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = nil,
}
VT_SAYA = {
  [CHAR_SOUND_ATTACKED] = { 'saya_dmg1.mp3', 'saya_dmg2.mp3', 'saya_dmg3.mp3' },
  [CHAR_SOUND_DOH] = 'saya_are1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'saya_dead1.mp3', 'saya_dead2.mp3' },
  -- [CHAR_SOUND_EEUH] = {'chise_slowclimb.mp3'}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'chise_note1.mp3'},
  [CHAR_SOUND_HAHA] = { 'saya_laugh2.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'saya_star1.mp3', 'saya_laugh1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'saya_jump4.mp3' },                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'saya_grab.mp3',                               -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'silent.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'saya_ls1.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'saya_getup.mp3',                          -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'saya_dmg2.mp3' },                        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'saya_hm1.mp3',                                -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'saya_dmg3.mp3',                              -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3',}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'saya_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'saya_atk2.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'saya_atk1.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'saya_bthrow1.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'silent.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'saya_are1.mp3',                     -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'chise_uh3.mp3'}, -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = 'chise_fall.mp3', -- Falling
  [CHAR_SOUND_WAH2] = 'saya_throw.mp3',                                                -- Throw Object
  [CHAR_SOUND_WHOA] = 'saya_ledgegrab.mp3',                                            -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'saya_longjump.mp3' },                                        -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'saya_atk3.mp3' },                                -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'saya_jump1.mp3', 'saya_jump2.mp3', 'saya_jump3.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'chise_yawn.mp3'},
}

VT_KISAKI = {
  [CHAR_SOUND_ATTACKED] = { 'sfx_smrpg_hit1.mp3' },
  [CHAR_SOUND_DOH] = 'kisaki_oh.mp3',               -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'kisaki_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'kisaki_nanoja.mp3' },      -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'kisaki_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'kisaki_atk5.mp3' },      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',     -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'kisaki_rest.mp3',
  --[CHAR_SOUND_GROUND_POUND_WAH] = {'nagisa_atk4.mp3'},
  [CHAR_SOUND_LETS_A_GO] = { 'kisaki_ls1.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'kisaki_levelexit.mp3' },                  -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                      -- Touch Fire
  [CHAR_SOUND_OOOF] = 'kisaki_hm2.mp3',                                -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sfx_smrpg_hit1.mp3',                           -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'kisaki_throw.mp3' },                     -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'kisaki_atk2.mp3',                          -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'kisaki_atk3.mp3',                          -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'kisaki_throw.mp3' },               -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                -- Boing
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                             -- Drop off of ledge + Fall off Ledge
  --[CHAR_SOUND_UH2] = {'nagisa_atk1.mp3'}, -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'kisaki_what.mp3',                           -- Falling
  [CHAR_SOUND_WAH2] = { 'kisaki_throw.mp3' },                          -- Throw Object
  [CHAR_SOUND_WHOA] = 'kisaki_oh.mp3',                                 -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'kisaki_atk4.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'kisaki_atk4.mp3' },              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'kisaki_atk1.mp3', 'kisaki_atk3.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'kisaki_hm1.mp3' },
}

VT_REIJO = {
  [CHAR_SOUND_ATTACKED] = { 'reijo_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'reijo_dmg1.mp3',                                -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'reijo_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'reijo_hisatsu.mp3' },                        -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'reijo_star1.mp3', 'reijo_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'reijo_atk10.mp3' },                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                       -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'reijo_rest.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'reijo_atk5.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'reijo_ls1.mp3' },                                        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'reijo_getup.mp3' },                                       -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                      -- Touch Fire
  [CHAR_SOUND_OOOF] = 'reijo_eh.mp3',                                                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'reijo_dmg3.mp3',                                               -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'reijo_atk11.mp3' },                                      -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'reijo_atk7.mp3',                                           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'reijo_atk6.mp3',                                           -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'reijo_bthrow1.mp3', 'reijo_bthrow2.mp3' },         -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                -- Boing
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                             -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'reijo_atk1.mp3' },                                             -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                     -- Falling
  [CHAR_SOUND_WAH2] = { 'reijo_takethis.mp3', 'reijo_howsthis.mp3' },                  -- Throw Object
  [CHAR_SOUND_WHOA] = 'reijo_eh.mp3',                                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'reijo_longjump.mp3' },                                       -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'reijo_atk11.mp3' },                              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'reijo_atk2.mp3', 'reijo_atk4.mp3', 'reijo_atk8.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'reijo_yawn.mp3' },
}

VT_SHUN = {
  [CHAR_SOUND_ATTACKED] = { 'shun_dmg1.mp3', 'shun_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'shun_ara1.mp3',           -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'shun_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'shun_slowclimb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'.mp3'},
  [CHAR_SOUND_HAHA] = { 'shun_laugh1.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'shun_star1.mp3', 'shun_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'shun_jump4.mp3' },                       -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'shun_ara2.mp3',                              -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = '.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'shun_ls1.mp3', 'shun_ls2.mp3' },      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'shun_levelexit.mp3' },                 -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'shun_dmg3.mp3' },                       -- Touch Fire
  [CHAR_SOUND_OOOF] = 'shun_dmg1.mp3',                              -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'shun_dmg2.mp3',                             -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'shun_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'shun_atk2.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'shun_jump1.mp3',    -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'shun_bthrow1.mp3', 'shun_bthrow2.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'shun_laugh2.mp3' },                         -- Boing
  [CHAR_SOUND_UH] = 'shun_ara1.mp3',                                         -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'shun_jump1.mp3' },                                   -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'shun_bthrow1.mp3' },                       -- Throw Object
  [CHAR_SOUND_WHOA] = 'shun_ara1.mp3',                              -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'shun_laugh2.mp3' },                       -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'shun_laugh2.mp3' },           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'shun_atk1.mp3', 'shun_jump3.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'shun_yawn.mp3' },
}

VT_CHILD_SHUN = {
  [CHAR_SOUND_ATTACKED] = { 'young_dmg1.mp3', 'young_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'young_are1.mp3',           -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'young_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'young_slowclimb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'.mp3'},
  [CHAR_SOUND_HAHA] = { 'young_laugh1.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'young_star1.mp3', 'young_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'young_atk2.mp3' },                         -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'young_heavy.mp3',                              -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'young_imatired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'young_ls1.mp3', 'young_ls2.mp3' },      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'young_levelexit.mp3' },                  -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'young_onfire.mp3' },                      -- Touch Fire
  [CHAR_SOUND_OOOF] = 'young_are1.mp3',                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'young_dmg2.mp3',                              -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'young_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'young_jump2.mp3',    -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'young_atk2.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'young_bthrow1.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'young_laugh1.mp3' },     -- Boing
  [CHAR_SOUND_UH] = 'young_idk.mp3',                      -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'young_atk2.mp3' },                -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'young_atk1.mp3' },                            -- Throw Object
  [CHAR_SOUND_WHOA] = 'young_are1.mp3',                                -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'young_longjump.mp3' },                       -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'young_longjump.mp3' },           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'young_jump1.mp3', 'young_jump2.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'shun_yawn.mp3'},
}

VT_RUMI = {
  [CHAR_SOUND_ATTACKED] = { 'Rumi_dmg1.mp3', 'Rumi_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'Rumi_dmg2.mp3',                              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Rumi_Dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'Rumi_haha.mp3' },                         -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Rumi_star.mp3', 'Rumi_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'Rumi_punch1.mp3' },                     -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'Rumi_grab.mp3',                             -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'Rumi_sleepy.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'Rumi_longjump.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'Rumi_letago.mp3' },        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'Rumi_levelfail.mp3' },      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'Rumi_dmg1.mp3' },            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Rumi_dmg2.mp3',                   -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Rumi_dmg1.mp3',                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Rumi_longjump.mp3' },      -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Rumi_punch2.mp3',            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Rumi_punch1.mp3',            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Rumi_bowser.mp3' },  -- Bowser Throw
  [CHAR_SOUND_UH] = 'Rumi_dmg2.mp3',                     -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'Rumi_punch1.mp3' },              -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'Rumi_Falling.mp3',            -- Falling
  [CHAR_SOUND_WAH2] = { 'Rumi_longjump.mp3' },           -- Throw Object
  [CHAR_SOUND_WHOA] = 'Rumi_dmg2.mp3',                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Rumi_longjump.mp3' },          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Rumi_jump3.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Rumi_punch2.mp3' },      -- 1st Jump(s)
  [CHAR_SOUND_EEUH] = 'Rumi_grab.mp3',
}
-- ================
-- Shanhaijing End
-- ================
-- ================
-- RedWinter Start
-- ================
VT_SHIGURE = {
  [CHAR_SOUND_ATTACKED] = { 'shigure_dmg1.mp3', 'shigure_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'shigure_ah1.mp3',            -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'shigure_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'shigure_slowclimb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'shigure_atk1.mp3' },
  [CHAR_SOUND_HAHA] = { 'shigure_laugh.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'shigure_star1.mp3', 'shigure_star2.mp3', 'shigure_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'shigure_jump4.mp3' },                                               -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'shigure_slowclimb.mp3',                                                 -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'shigure_hm2.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'shigure_ls1.mp3' },                                              -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'shigure_getup1.mp3', 'shigure_getup2.mp3' },                      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'shigure_dmg3.mp3' },                                               -- Touch Fire
  [CHAR_SOUND_OOOF] = 'shigure_eh1.mp3',                                                       -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'shigure_dmg1.mp3',                                                     -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'shigure_atk2.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'shigure_jump3.mp3',    -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'shigure_atk1.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'shigure_star2.mp3', 'shigure_wontwork.mp3' }, -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'silent.mp3'}, -- Boing
  [CHAR_SOUND_UH] = 'shigure_huh1.mp3',                                           -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'shigure_jump1.mp3' },                                     -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'shigure_shock.ogg', -- Falling
  [CHAR_SOUND_WAH2] = { 'shigure_throw1.mp3', 'shigure_throw2.mp3' },      -- Throw Object
  [CHAR_SOUND_WHOA] = 'shigure_hm1.mp3',                                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'shigure_longjump.mp3' },                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'shigure_longjump.mp3' },             -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'shigure_jump1.mp3', 'shigure_jump3.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'silent.mp3'},
}

VT_MOMIJI = {
  [CHAR_SOUND_ATTACKED] = { 'momiji_uu.mp3', 'momiji_hidoi.mp3' },
  [CHAR_SOUND_DOH] = 'momiji_wah.mp3',                                  -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'momiji_dead.mp3' },
  [CHAR_SOUND_HAHA] = { 'momiji_desu1.mp3' },                           -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'momiji_star1.mp3' },                     -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'momiji_atk3.mp3' },                          -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                         -- Object Pick-up
  [CHAR_SOUND_LETS_A_GO] = { 'momiji_levelselect.mp3' },                -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'momiji_mou.mp3', 'momiji_levelexit.mp3' }, -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'momiji_fire.mp3' },                         -- Touch Fire
  [CHAR_SOUND_OOOF] = 'momiji_wah.mp3',                                 -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'momiji_uu.mp3',                                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'momiji_atk1.mp3' },                       -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'momiji_atk2.mp3',                           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'momiji_atk5.mp3',                           -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'momiji_bthrow.mp3' },               -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                 -- Boing
  [CHAR_SOUND_UH] = 'momiji_wah.mp3',                                   -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'momiji_atk3.mp3' },                             -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'momiji_fall.mp3',                            -- Falling
  [CHAR_SOUND_WAH2] = { 'momiji_bthrow.mp3' },                          -- Throw Object
  [CHAR_SOUND_WHOA] = 'momiji_ledgegrab.mp3',                           -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'momiji_atk3.mp3' },                           -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'momiji_atk3.mp3' },               -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'momiji_atk5.mp3', 'momiji_atk4.mp3' },  -- 1st Jump(s)
}

VT_CHERINO = {
  [CHAR_SOUND_ATTACKED] = { 'cherino_dmg1.mp3', 'cherino_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'cherino_dmg1.mp3',                    -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'cherino_dying.mp3' },
  [CHAR_SOUND_HRMM] = 'cherino_grab.mp3',                   -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'cherino_groundPound.mp3' },
  [CHAR_SOUND_HAHA] = { 'cherino_laugh.mp3' },              -- Landing after backflip
  [CHAR_SOUND_HAHA_2] = 'cherino_laugh.mp3',                -- Landing on Water after a fall
  [CHAR_SOUND_HERE_WE_GO] = { 'cherino_star.mp3' },         -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'cherino_jump2.mp3' },            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_LETS_A_GO] = { 'cherino_letsGo.mp3' },        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'cherino_levelFail.mp3' },      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'cherino_burn.mp3' },            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'cherino_hanase.mp3',                 -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'cherino_dmg2.mp3',                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'cherino_kick.mp3' },          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'cherino_punch2.mp3',            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'cherino_punch1.mp3',            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'cherino_bowser.mp3' },  -- Bowser Throw
  [CHAR_SOUND_UH] = 'cherino_eh.mp3',                       -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'cherino_jump1.mp3' },               -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'cherino_burn.mp3',               -- Falling
  [CHAR_SOUND_WAH2] = { 'cherino_jump1.mp3' },              -- Throw Object
  [CHAR_SOUND_WHOA] = 'cherino_grab.mp3',                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'cherino_yahoo.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'cherino_yahoo.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'cherino_jump1.mp3' },       -- 1st Jump(s)
}

VT_TOMOE = {
  [CHAR_SOUND_ATTACKED] = { 'tomoe_dmg1.mp3', 'tomoe_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'tomoe_dmg1.mp3',                                   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'tomoe_dying.mp3' },
  [CHAR_SOUND_HRMM] = 'tomoe_grab.mp3',                                  -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'tomoe_groundPound.mp3' },
  [CHAR_SOUND_HAHA] = { 'tomoe_laugh.mp3' },                             -- Landing after backflip
  [CHAR_SOUND_HAHA_2] = 'tomoe_laugh.mp3',                               -- Landing on Water after a fall
  [CHAR_SOUND_HERE_WE_GO] = { 'tomoe_star.mp3', 'tomoe_star2.mp3' },     -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'tomoe_jump2.mp3' },                           -- 2nd Jump + Dive Attack
  [CHAR_SOUND_LETS_A_GO] = { 'tomoe_letsGo.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'tomoe_levelFail.mp3' },                     -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'tomoe_dmg2.mp3' },                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'tomoe_ara.mp3',                                   -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'tomoe_dmg2.mp3',                                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'tomoe_yahoo.mp3' },                        -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'tomoe_punch2.mp3',                           -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'tomoe_punch1.mp3',                           -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'tomoe_bowser.mp3' },                 -- Bowser Throw
  [CHAR_SOUND_UH] = 'tomoe_ara.mp3',                                     -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'tomoe_jump1.mp3' },                              -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'tomoe_ara.mp3',                               -- Falling
  [CHAR_SOUND_WAH2] = { 'tomoe_jump1.mp3' },                             -- Throw Object
  [CHAR_SOUND_WHOA] = 'tomoe_grab.mp3',                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'tomoe_yahoo.mp3' },                            -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'tomoe_yahoo.mp3' },                -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'tomoe_jump1.mp3', 'tomoe_jump1_1.mp3' }, -- 1st Jump(s)
}

VT_MARINA = {
  [CHAR_SOUND_ATTACKED] = { 'marina_dmg1.mp3', 'marina_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'marina_dmg1.mp3',                                    -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'marina_dying.mp3' },
  [CHAR_SOUND_HRMM] = 'marina_oh.mp3',                                     -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'marina_groundPound.mp3' },
  [CHAR_SOUND_HAHA] = { 'marina_laugh.mp3' },                              -- Landing after backflip
  [CHAR_SOUND_HAHA_2] = 'marina_laugh.mp3',                                -- Landing on Water after a fall
  [CHAR_SOUND_HERE_WE_GO] = { 'marina_star.mp3' },                         -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'marina_jump2.mp3' },                            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_LETS_A_GO] = { 'marina_letsGo.mp3' },                        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'marina_levelFail.mp3' },                      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'marina_dmg2.mp3' },                            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'marina_oh.mp3',                                     -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'marina_dmg2.mp3',                                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'marina_kick.mp3' },                          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'marina_punch2.mp3',                            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'marina_punch1.mp3',                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'marina_bowser.mp3' },                  -- Bowser Throw
  [CHAR_SOUND_UH] = 'marina_oh.mp3',                                       -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'marina_jump1.mp3' },                               -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'marina_falling.mp3',                            -- Falling
  [CHAR_SOUND_WAH2] = { 'marina_jump1.mp3' },                              -- Throw Object
  [CHAR_SOUND_WHOA] = 'marina_oh.mp3',                                     -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'marina_yahoo.mp3' },                             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'marina_yahoo.mp3' },                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'marina_jump1.mp3', 'marina_jump1_1.mp3' }, -- 1st Jump(s)
}
VT_NODOKA = {
  [CHAR_SOUND_ATTACKED] = { 'Nodoka_surprised.ogg', 'Nodoka_wah.ogg' },
  [CHAR_SOUND_DOH] = 'Nodoka_are2.ogg',                   -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Nodoka_defeat.ogg' },
  [CHAR_SOUND_HERE_WE_GO] = { 'Nodoka_hotsrpings.ogg' },  -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'Nodoka_gambare.ogg' },      -- Level Select
  [CHAR_SOUND_HRMM] = 'Nodoka_uhlow.ogg',                 -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'Nodoka_de.ogg' },              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'Nodoka_ito.ogg' },            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Nodoka_eh.ogg',                    -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Nodoka_eh.ogg',                   -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Nodoka_yah3.ogg' },         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Nodoka_ta.ogg',               -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Nodoka_de.ogg',               -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Nodoka_dozo.ogg' },   -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'Nodoka_dozo.ogg' },              -- Throw Object
  [CHAR_SOUND_UH] = 'Nodoka_oh.ogg',                      -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'Nodoka_de.ogg' },                 -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'Nodoka_surprised.ogg',         -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'Nodoka_ahah.ogg' },      -- Boing
  [CHAR_SOUND_WHOA] = 'Nodoka_ah2.ogg',                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Nodoka_ka2.ogg' },              -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Nodoka_ahah.ogg' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Nodoka_oh.ogg' },         -- 1st Jump(s)
  [CHAR_SOUND_HAHA] = 'Nodoka_hehe.ogg',
  [CHAR_SOUND_MAMA_MIA] = 'Nodoka_are.ogg',
  [CHAR_SOUND_YAWNING] = 'Nodoka_yawn2.ogg',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'Nodoka_yah3.ogg' },
  [CHAR_SOUND_EEUH] = { 'Nodoka_hehe.ogg' }, -- Slow Get up from ledge
  [CHAR_SOUND_HAHA_2] = 'Nodoka_hehe.ogg',   -- Landing on Water after a fall
}

VT_MERU = {
  [CHAR_SOUND_ATTACKED] = { 'Meru_ATTACKED1.ogg', 'Meru_ATTACKED2.ogg' },
  [CHAR_SOUND_DOH] = 'Meru_ATTACKED2.ogg',                                                       -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Meru_DYING.ogg' },
  [CHAR_SOUND_HAHA] = { 'Meru_HAHA.ogg' },                                                       -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Meru_HEREWEGO.ogg', 'Meru_HEREWEGO2.ogg', 'Meru_HEREWEGO3.ogg' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'Meru_LETSAGO.ogg', 'Meru_LETSAGO2.ogg' },                          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'Meru_MAMAMIA.ogg' },                                                -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                                  -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'Meru_HOOHOO.ogg' },                                                   -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'Meru_ATTACKED1.ogg' },                                               -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Meru_OOOF.ogg',                                                           -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Meru_OOOF2.ogg',                                                         -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Meru_PUNCH_HOO.ogg' },                                             -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Meru_PUNCH_WAH.ogg',                                                 -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Meru_YAH_WAH_HOO.ogg',                                               -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Meru_WAH2.ogg' },                                            -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'Meru_WAH2.ogg' },                                                       -- Throw Object
  [CHAR_SOUND_UH] = 'Meru_UH.ogg',                                                               -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'Meru_ATTACKED1.ogg' },                                                   -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'Meru_DYING.ogg',                                                      -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                          -- Boing
  [CHAR_SOUND_WHOA] = 'Meru_UH.ogg',                                                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Meru_YAHOO.ogg' },                                                     -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Meru_YAHOO_WAHA_YIPPEE.ogg' },                             -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Meru_YAH_WAH_HOO.ogg', 'Meru_YAH_WAH_HOO2.ogg' },                -- 1st Jump(s)
  [CHAR_SOUND_EEUH] = { 'Meru_LETSAGO.ogg' },                                                    -- Slow climb from ledge
}

VT_TAKANE = {
  [CHAR_SOUND_ATTACKED] = { 'Takane_ATTACKED.ogg' },
  [CHAR_SOUND_DOH] = 'Takane_DOH.ogg',                                                           -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Takane_DYING.ogg' },
  [CHAR_SOUND_HAHA] = { 'Takane_HAHA.ogg' },                                                     -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Takane_HEREWEGO.ogg', 'Takane_HEREWEGO2.ogg' },                   -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'Takane_LETSAGO.ogg' },                                             -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'Takane_MAMAMIA.ogg' },                                              -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                                  -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'Takane_HOOHOO.ogg' },                                                 -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'Takane_ATTACKED.ogg' },                                              -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Takane_OOOF2.ogg',                                                        -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Takane_OOOF2.ogg',                                                       -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Takane_PUNCH_HOO.ogg' },                                           -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Takane_HOOHOO.ogg',                                                  -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Takane_YAH_WAH_HOO2.ogg',                                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Takane_YAHOO_WAHA_YIPPEE.ogg' },                             -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'Takane_YAHOO_WAHA_YIPPEE.ogg' },                                        -- Throw Object
  [CHAR_SOUND_UH] = 'Takane_UH2.ogg',                                                            -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'Takane_DYING.ogg',                                                    -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                          -- Boing
  [CHAR_SOUND_WHOA] = 'Takane_UH.ogg',                                                           -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Takane_YAHOO.ogg' },                                                   -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Takane_YAHOO_WAHA_YIPPEE.ogg' },                           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Takane_YAH_WAH_HOO.ogg', 'Takane_YAH_WAH_HOO2.ogg' },            -- 1st Jump(s)
}

VT_YAKUMO = {
  [CHAR_SOUND_ATTACKED] = { 'sfx_ff6_fistattack.mp3', 'sfx_smw_bossstun.mp3', 'sfx_mmx_hurt.mp3' },
  [CHAR_SOUND_DOH] = 'sfx_ml_bump.mp3',                                                           -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'yakumo_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'yakumo_laugh1.mp3' },                                                     -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'yakumo_star1.mp3', 'yakumo_star3.mp3', 'yakumo_star2.mp3' },                   -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'yakumo_levelselect.mp3' },                                             -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'yakumo_levelexit2.mp3' },                                              -- Getting up after thrown out of level
  [CHAR_SOUND_HRMM] = 'yakumo_grab.mp3',                                                  -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'sfx_smw_jump.mp3' },                                                 -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                              -- Touch Fire
  [CHAR_SOUND_OOOF] = 'yakumo_ledgegrab.mp3',                                                        -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sfx_smrpg_drop.mp3',                                                       -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'sfx_ssb64_atk3.mp3' },                                           -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sfx_ssb64_atk2.mp3',                                                  -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sfx_ssb64_atk1.mp3',                                            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sfx_smrpg_fireball.mp3' },                             -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'yakumo_throw.mp3' },                                        -- Throw Object
  [CHAR_SOUND_UH] = 'yakumo_sneeze.mp3',                                                            -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                                    -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                          -- Boing
  [CHAR_SOUND_WHOA] = 'yakumo_ledgegrab.mp3',                                                           -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'yakumo_laugh4.mp3' },                                                   -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'yakumo_laugh2.mp3' },                           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'yakumo_jump1.mp3', 'sfx_smw_jump.mp3' },            -- 1st Jump(s)
  [CHAR_SOUND_IMA_TIRED] = 'yakumo_sigh.mp3',
}
-- ================
-- RedWinter End
-- ================
